/* Wiktor Zychla, 2003 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace Example
{
  public class CKomponent : UserControl
  {
    Button b1, b2;

    public CKomponent() 
    {
      b1      = new Button();
      b1.Text = "1";
      b1.Dock = DockStyle.Fill;
      b1.Click += new EventHandler( bt_Click );

      b2      = new Button();
      b2.Text = "2";
      b2.Size = new Size( 40, 40 );
      b2.Dock = DockStyle.Right;
      b2.Click += new EventHandler( bt_Click );

      this.Controls.AddRange( new Control[] { b1, b2 } );
    }

    public void bt_Click( object sender, EventArgs e )
    {
      MessageBox.Show( ((Control)sender).Text );
    } 
  }

  public class CMainForm : Form
  {  
    CKomponent ck1, ck2;

    public CMainForm() 
    {
      ck1      = new CKomponent();
      ck1.Text = "Komponent 1";
      ck1.BackColor = Color.Red;
      ck1.Font = new Font( "Tahoma", 8 );
      ck1.Size = new Size( 50, 50 );
      ck1.Dock = DockStyle.Fill;

      ck2      = new CKomponent();
      ck2.Text = "Komponent 2";
      ck2.Font = new Font( "Courier", 12 );
      ck2.Dock = DockStyle.Top;

      this.Controls.AddRange( new Control[] { ck1, ck2 } );
    }

    public static void Main()
    {    
      Application.Run( new CMainForm() );
    }
  }
}


